﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Core.DbTuples" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Świadectwo pracy</title>
		<script runat="server">
		    
    public class InfoParams : ContextBase {
        public InfoParams(Context context) : base(context) {
            DbTuple tp = (DbTuple)context[typeof(DbTuple)];
            naDzien = (Date)tp.Fields["aktualna"];
        }

        Date naDzien;
        [Priority(1)]
        [Caption("Na dzień")]
        public Date NaDzien {
            get { return naDzien; }
            set {
                naDzien = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        int iloscKopii = 1;
        [Priority(2)]
        [Caption("Ilość kopii")]
        public int IloscKopii {
            get { return iloscKopii; }
            set {
                if (value <= 0)
                    value = 1;
                iloscKopii = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    InfoParams info;
    [Context]
    public InfoParams Info {
        set { info = value; }
    }

    string koniec = "nadal";    

    void OnContextLoad(Object sender, EventArgs args) {
        DbTuple tp = (DbTuple)dc[typeof(DbTuple)];
        string dots = "nie dotyczy";
        
        Date aktualna = (Date)tp.Fields["aktualna"];
        if (aktualna == Date.Empty)
            throw new Exception("Brak możliwości wykonania wydruku dla dokumentu tylko z załącznikiem");        
        FromTo okresZatrudnienia = tp.Okres;
        
        string Grid1DS = (string)tp.Fields["grid1DS"];
        ArrayList okresyNieskładkowe = new ArrayList();
        GetOkresyLst(Grid1DS, ref okresyNieskładkowe);
        Grid1.DataSource = okresyNieskładkowe;
        Grid1.Visible = okresyNieskładkowe.Count != 0;

        string Grid2DS = (string)tp.Fields["grid2DS"];
        ArrayList okresyBezpłatne = new ArrayList();
        GetOkresyLst(Grid2DS, ref okresyBezpłatne);
        Grid2.DataSource = okresyBezpłatne;
        Grid2.Visible = okresyBezpłatne.Count != 0;

        if (okresyBezpłatne.Count == 0)
            urlopbezplatny.EditValue = dots;
        else
            urlopbezplatny.EditValue = "";
        if (okresyNieskładkowe.Count == 0)
            okresyNS.EditValue = "<strong>0</strong> dni";
        else
            okresyNS.EditValue = "";
        wychowawczy.EditValue = tp.Fields["wychowawczy"];

        string op188 = (string)tp.Fields["opieka188"]; 
        opieka188.EditValue = op188 + (!op188.Contains("godz") && !op188.Contains("dni") ? " </strong>dni" : "");
        bool op188cz = op188.Contains("godz"); 
        opieka188opis.EditValue = "(liczba " + (op188cz ? "godz." : "dni") + " zwolnienia wykorzystanego w roku kalendarzowym, w którym ustał stosunek pracy)";

        wypoczynkowy.EditValue = tp.Fields["wypoczynkowy"];
        wypoczynkowyT.EditValue = tp.Fields["wypoczynkowyT"];
        wypoczynkowyG.EditValue = tp.Fields["wypoczynkowyG"];
        string ekwWyp = (string)tp.Fields["ekwiwalentG"];
        ekwiwalentG.EditValue = string.Format(", w tym <strong>{0}</strong> godz. ekwiwalentu za czas urlopu", ekwWyp);        
        wypoczynkowy167.EditValue = tp.Fields["wypoczynkowy167"];
        wypoczynkowy167G.EditValue = tp.Fields["wypoczynkowy167G"];
        służba.EditValue = tp.Fields["służba"];
        szWarunki.EditValue = tp.Fields["szWarunki"];
        dodUrlop.EditValue = tp.Fields["dodUrlop"];
        nieWyn.EditValue = tp.Fields["nieWyn"];
        string kom = (string)tp.Fields["komornik"];
        if (kom.Length == 0)
            komornik.EditValue = "<strong>" + dots + "</strong>";
        else
            komornik.EditValue = kom;
        string pozostDni = (string)tp.Fields["pozostDni"];
        string pozostGodz = (string)tp.Fields["pozostGodz"];
        string infoUzup = "";
        try { infoUzup = (string)tp.Fields["infoUzupelniajace"]; }
        catch { }
        if (pozostDni.Length == 0 && pozostGodz.Length == 0 && infoUzup.Length == 0)
            dodatkowe.EditValue = dots;
        else {
            string str = "";
            if (pozostDni.Length != 0 || pozostGodz.Length != 0)
                str = string.Format("</strong>Strony skorzystały z możliwości wynikającej z art. 171 § 3 KP i postanowiły" +
                    " o wykorzystaniu <strong>{0}</strong> dni (<strong>{1}</strong> godz.) urlopu wypoczynkowego w czasie kolejnego zawartego miedzy nimi stosunku pracy.",
                    pozostDni == "" ? "0" : pozostDni, pozostGodz == "" ? "0" : pozostGodz);
            if (infoUzup.Length != 0) {
                if (str != "")
                    str += "<br/>";
                str += infoUzup;
            }
            dodatkowe.EditValue = str;
        }
        skrOkres.EditValue = tp.Fields["skrOkres"];
        wynagrodz92.EditValue = tp.Fields["wynagrodz92"];
                
        Pracownik pracownik = (Pracownik)tp.Fields["Pracownik"];
        PracHistoria historia = pracownik[okresZatrudnienia.To];
        bool stPelne = (bool)tp.Fields["stPelne"];
                
        labelMiejscowosc.EditValue = GetMiejscowosc(historia);
        labelData.EditValue = info.NaDzien.ToString();

        KadryModule module = KadryModule.GetInstance(dc);
        sadpracy.EditValue = module.Config.Wydruki.SądPracy.Length > 0 ?
            module.Config.Wydruki.SądPracy : "Sądu Rejonowego - Sądu Pracy w ..............................";

        string s = "";
        string last = "";
        string firma = "";
        Date data = Date.Empty;
        Periods okresy = Periods.Empty;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia)) {
            if (last != GetStanowisko(ph, stPelne)) {
                last = GetStanowisko(ph, stPelne);
                if (s == "")
                    s = "<strong><LI>" + last;
                else {
                    s += " </strong>od<strong> " + okresy.From + " </strong>do<strong> " + (okresy.To != Date.MaxValue ? okresy.To.ToString() : koniec) + "</strong><LI><strong>" + last;
                    okresy = Periods.Empty;
                }
            }
            okresy += ph.Etat.EfektywnyOkres;
            if (data == Date.Empty)
                data = ph.Etat.Okres.From;
            if (ph.Etat.DataPrzejeciaPracownika != Date.Empty && ph.Etat.DataPrzejeciaPracownika != data && ph.Etat.EfektywnyOkres.Contains(ph.Etat.DataPrzejeciaPracownika)) {
                if (firma != "")
                    firma += "<br/>";
                firma += string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong> (przejście w trybie art. 23' KP)",
                    ph.Etat.PoprzedniPracodawca,
                    data,
                    ph.Etat.DataPrzejeciaPracownika.AddDays(-1));
                data = ph.Etat.DataPrzejeciaPracownika;
            }
        }
        if (firma != "")
            firma += string.Format("<br/><strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong>",
                DaneFirmy(historia),
                data,
                (okresZatrudnienia.To != Date.MaxValue ? okresZatrudnienia.To.ToString() : koniec));
        else
            firma = string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong>",
                DaneFirmy(historia),
                okresZatrudnienia.From,
                (okresZatrudnienia.To != Date.MaxValue ? okresZatrudnienia.To.ToString() : koniec));

        if (okresy != Periods.Empty)
            s += " </strong>od<strong> " + okresy.From + " </strong>do<strong> " + (okresy.To != Date.MaxValue ? okresy.To.ToString() : koniec) + "</strong>";

        ArrayList wymiary = new ArrayList();
        Fraction currw = historia.Etat.Wymiar;
        Fraction lastw = Fraction.Zero;
        FromTo efektywny = FromTo.Empty;
        okresy = Periods.Empty;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia)) {
            efektywny = ph.Etat.EfektywnyOkres;
            ZbiegPracyIRodzicielstwa zpr = (efektywny.To != Date.MaxValue) ? (ZbiegPracyIRodzicielstwa)pracownik.ZbiegiPracyIRodzicielstwa[efektywny.To] : null;
            currw = (zpr != null) ? zpr.WymiarEtatu : ph.Etat.Wymiar;
            if (lastw != currw) {
                if (okresy != Periods.Empty)
                    wymiary.Add(new DictionaryEntry(lastw, okresy));
                lastw = currw;
                okresy = Periods.Empty;
            }
            okresy += efektywny;
        }

        if (okresy != Periods.Empty)
            wymiary.Add(new DictionaryEntry(lastw, okresy));

        string wymiar = "";
        if (wymiary.Count < 2)
            wymiar = "<strong>" + currw + "</strong> etatu.<br/>";
        else {
            string ss = "";
            foreach (DictionaryEntry de in wymiary) {
                Periods pe = (Periods)de.Value;
                ss += "<li><strong>" + (Fraction)de.Key + "</strong> etatu od <strong>" + pe.From + "</strong> do <strong>" + (pe.To != Date.MaxValue ? pe.To.ToString() : koniec) + "</strong></li>";
            }
            wymiar = ss;
        }

        labelZatrudnienie.EditValue = string.Format("{0}<br/>w wymiarze: {1}", firma, wymiar);
        labelStanowisko.EditValue = s;
        labelPrzyczyna.EditValue = "<li>" + historia.Etat.PrzyczynaRozwUmowy;
        
        desc1.Visible = desc2.Visible = desc3.Visible = desc4.Visible = desc5.Visible = desc6.Visible =
            desc7.Visible = desc8.Visible = desc9.Visible = desc10.Visible = desc11.Visible = desc12.Visible = (bool)tp.Fields["Objasnienia"];

        ArrayList al = new ArrayList();
        for (int i = 0; i < info.IloscKopii; i++)
            al.Add(historia);
        DataRepeater1.DataSource = al;
    }

    void GetOkresyLst(string Grid2DS, ref ArrayList lista) {
        if (Grid2DS.Length != 0) {
            string[] lines = Grid2DS.Split('#');
            lista.AddRange(lines);
            lista.RemoveAt(lines.Length - 1);
        }
    }
    
    string GetStanowisko(PracHistoria ph, bool stPelne) {
        string stanowiskoPelne = "";
        if (stPelne)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }
    
    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }
    
    string DaneFirmy(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string nazwa = core.Config.Firma.Pieczątka.Nazwa;
        string regon = core.Config.Firma.Pieczątka.REGON;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
            if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
        }
        PieczątkaREGON.EditValue = regon;

        return nazwa;
    }
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        string line = (string)args.Row;
        string[] values = line.Split('|');
        if (values.Length > 0) {
            FromTo okres = FromTo.Parse(values[0]);
            col1OkresOd.EditValue = okres.From;
            col1OkresDo.EditValue = okres.To;
        }
        if (values.Length > 1)
            col1Nazwa.EditValue = values[1];
    }

    void Grid2_BeforeRow(Object sender, RowEventArgs args) {
        string line = (string)args.Row;
        string[] values = line.Split('|');
        if (values.Length > 0) {
            FromTo okres = FromTo.Parse(values[0]);
            col2OkresOd.EditValue = okres.From;
            col2OkresDo.EditValue = okres.To;
        }
        if (values.Length > 1)
            col2Nazwa.EditValue = values[1];
    }
    
	</script>

	<meta content="False" name="vs_showGrid">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
	<meta content="C#" name="CODE_LANGUAGE">
	<meta content="JavaScript" name="vs_defaultClientScript">
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ŚwiadectwoPracyDokDodatkowy" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" oncontextload="OnContextLoad"></EA:DATACONTEXT>
            <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" Width="100%">
            <ea:SectionMarker ID="SectionMarker1" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Świadectwo pracy" runat="server"></cc1:reportheader>
			<table id="Table0" cellSpacing="0" width="100%" columns="1" style="font-size: 10pt; font-family: tahoma; text-align:right">
			<tbody>
				<tr>
					<td valign="top" align="right">
						<ea:datalabel id="labelMiejscowosc" runat="server"></ea:datalabel>,
						<ea:datalabel id="labelData" runat="server"></ea:datalabel>
					</td>
                </tr>
            </tbody>
            </table>
			<p></p>
			<font face="Tahoma" size="2">
				<p style="text-align:left">
					REGON:
					<ea:datalabel id="PieczątkaREGON" runat="server"></ea:datalabel>
				</p>
			</font>

			<table id="Table1" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:left">
			<tbody>
				<tr>
					<td width="30px" valign="top" align="right">1.</td><td width="5px"></td>
					<td>Stwierdza się, że
						<ea:datalabel id="DataLabel2" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>
						<ea:datalabel id="Datalabel34" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:datalabel>,
                        imiona rodziców:
						<ea:datalabel id="Datalabel36" runat="server" DataMember="ImieOjca"></ea:datalabel>,
						<ea:datalabel id="Datalabel37" runat="server" DataMember="ImieMatki"></ea:datalabel>,
						<br/>
						<ea:datalabel id="DataLabel3" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="urodzona"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="urodzony"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>&nbsp;
						<ea:datalabel id="Datalabel38" runat="server" DataMember="Urodzony.Data"></ea:datalabel>&nbsp;
						<ea:datalabel id="Datalabel39" runat="server" DataMember="Urodzony.Miejsce"></ea:datalabel>,
						<br/>
						<ea:datalabel id="DataLabel1" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="była zatrudniona"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="był zatrudniony"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>&nbsp;w:
                        <br />
                        <ea:datalabel id="labelZatrudnienie" runat="server" Bold="false"></ea:datalabel> 
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">2.</td><td width="5px"></td>
					<td>W okresie zatrudnienia
						<ea:datalabel id="DataLabel11" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="pracownik wykonywał"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="pracownik wykonywał"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>
						pracę:
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right"></td><td width="5px"></td>
					<td>
						<ea:datalabel id="labelStanowisko" runat="server" Bold="False"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">3.</td><td width="5px"></td>
					<td>Stosunek pracy ustał w wyniku:</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right"></td><td width="5px"></td>
					<td>
						<ea:datalabel id="labelPrzyczyna" runat="server"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">4.</td><td width="5px"></td>
					<td>W okresie zatrudnienia pracownik:</td>
				</tr>
			</tbody>
			</table>
					
			<table id="Table6" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">1)</td><td width="5px"></td>
					<td>wykorzystał urlop wypoczynkowy w wymiarze&nbsp;
						<ea:datalabel id="wypoczynkowy" runat="server"></ea:datalabel>
						&nbsp;dni&nbsp;<ea:datalabel id="wypoczynkowyT" runat="server" Bold="False"></ea:datalabel>
						(<ea:datalabel id="wypoczynkowyG" runat="server"></ea:datalabel>
						&nbsp;godz.<ea:datalabel id="ekwiwalentG" runat="server" Bold="False"></ea:datalabel>)
                        <ea:Section ID="desc1" runat="server">
                            <em>(urlop wypoczynkowy wykorzystany w roku kalendarzowym, w którym ustał stosunek pracy),</em>
                        </ea:Section>
                        <br/>w tym
						<ea:datalabel id="wypoczynkowy167" runat="server"></ea:datalabel>&nbsp;dni
						(<ea:datalabel id="wypoczynkowy167G" runat="server"></ea:datalabel>&nbsp;godz.) 
						urlopu na żądanie
                        <ea:Section ID="desc2" runat="server">
                            <em>(urlop wypoczynkowy wykorzystany na podstawie art. 167<sup>2</sup> Kodeksu pracy w roku kalendarzowym, w którym ustał stosunek pracy)</em>
                        </ea:Section>
					</td>
				</tr>
                <tr>
					<td width="60px" valign="top" align="right">2)</td><td width="5px"></td>
					<td>korzystał z urlopu bezpłatnego:
                        <ea:datalabel id="urlopbezplatny" runat="server"></ea:datalabel>                    
                    </td>
				</tr>
            </tbody>
            </table>				

			<ea:pagebreak id="PageBreak5" runat="server" Required="False"></ea:pagebreak>
			
			<ea:Grid id="Grid2" runat="server" onbeforerow="Grid2_BeforeRow">
				<Columns>
					<ea:GridColumn runat="server" width="8" Align="Right" Caption="Lp" DataMember="#"></ea:GridColumn>
					<ea:GridColumn runat="server" width="20" Align="Right" ID="col2OkresOd" Caption="Okres~Od"></ea:GridColumn>
					<ea:GridColumn runat="server" width="20" Align="Right" ID="col2OkresDo" Caption="Okres~Do"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" ID="col2Nazwa" Caption="Nazwa okresu"></ea:GridColumn>
				</Columns>
			</ea:Grid>

            <ea:Section ID="desc3" runat="server">
			    <table id="Table2" cellSpacing="0" width="100%" columns="2" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			    <tbody>
				    <tr>
					    <td width="80px"></td>
					    <td valign="top" align="left">
						    <em>(okres trwania urlopu bezpłatnego i podstawa prawna jego udzielenia)</em>
					    </td>
				    </tr>
                </tbody>
                </table>
            </ea:Section>

			<ea:pagebreak id="PageBreak7" runat="server" Required="False"></ea:pagebreak>

			<table id="Table3" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">3)</td><td width="5px"></td>
					<td>wykorzystał urlop wychowawczy:&nbsp;
						<ea:datalabel id="wychowawczy" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc4" runat="server">
                            <em>(okres wykorzystanego urlopu wychowawczego)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">4)</td><td width="5px"></td>
					<td>był niezdolny do pracy przez okres
						<ea:datalabel id="wynagrodz92" runat="server"></ea:datalabel>&nbsp;dni
                        <ea:Section ID="desc5" runat="server">
                            <em>(liczba dni, za które pracownik otrzymał wynagrodzenie - zgodnie z art. 92 Kodeksu pracy,
                            w roku kalendarzowym, w którym ustał stosunek pracy)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">5)</td><td width="5px"></td>
					<td>wykorzystał zwolnienie od pracy przewidziane w art. 188 Kodeksu pracy:
						<ea:datalabel id="opieka188" runat="server"></ea:datalabel>
                        <ea:Section ID="desc6" runat="server">
                            <em><ea:datalabel id="opieka188opis" runat="server" Bold="false"></ea:datalabel></em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">6)</td><td width="5px"></td>
					<td>został zastosowany skrócony okres wypowiedzenia umowy o pracę na podstawie art. 
						36<sup>1</sup> § 1 Kodeksu pracy:
						<ea:datalabel id="skrOkres" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc7" runat="server">
                            <em>(okres, o który został skrócony okres wypowiedzenia, uprawniający do odszkodowania)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">7)</td><td width="5px"></td>
					<td>odbył służbę wojskową w okresie:
						<ea:datalabel id="służba" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc8" runat="server">
                            <em>(okres odbywania czynnej służby wojskowej lub jej form zastępczych)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">8)</td><td width="5px"></td>
					<td>wykonywał pracę w szczególnych warunkach lub w szczególnym charakterze:
						<ea:datalabel id="szWarunki" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc9" runat="server">
    						<em>(okresy wykonywania pracy oraz jej rodzaj i zajmowane stanowiska)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">9)</td><td width="5px"></td>
					<td>wykorzystał dodatkowy urlop albo inne uprawnienia lub świadczenia 
						przewidziane przepisami prawa pracy:
						<ea:datalabel id="dodUrlop" runat="server" Bold="false"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">10)</td><td width="5px"></td>
					<td>okresy nieskładkowe:&nbsp;
						<ea:datalabel id="okresyNS" runat="server" Bold="false"></ea:datalabel>
                    </td>
				</tr>
			</tbody>
			</table>
				
			<ea:pagebreak id="PageBreak2" runat="server" Required="False"></ea:pagebreak>
			
			<ea:Grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn runat="server" width="8" Align="Right" Caption="Lp" DataMember="#"></ea:GridColumn>
					<ea:GridColumn runat="server" width="20" Align="Right" ID="col1OkresOd" Caption="Okres nieskładkowy~Od"></ea:GridColumn>
					<ea:GridColumn runat="server" width="20" Align="Right" ID="col1OkresDo" Caption="Okres nieskładkowy~Do"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" ID="col1Nazwa" Caption="Nazwa okresu"></ea:GridColumn>
				</Columns>
			</ea:Grid>

            <ea:Section ID="desc10" runat="server">
			    <table id="Table7" cellSpacing="0" width="100%" columns="2" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			    <tbody>
				    <tr>
					    <td width="80px"></td>
					    <td valign="top" align="left">
						    <em>(okresy nieskładkowe, przypadające w okresie zatrudnienia wskazanym w ust. 1, 
						    uwzględniane przy ustalaniu prawa do emerytury lub renty)</em>
					    </td>
				    </tr>
			    </tbody>
			    </table>
            </ea:Section>
			
			<ea:pagebreak id="PageBreak3" runat="server" Required="False"></ea:pagebreak>
			
			<table id="Table8" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">11)</td><td width="5px"></td>
					<td>dni, za które pracownik nie zachował prawa do wynagrodzenia:
						<ea:datalabel id="nieWyn" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc11" runat="server">
                            <em>(dni, za które pracownik nie zachował prawa do wynagrodzenia, zgodnie z art. 92 
	    					    § 1<sup>1</sup> Kodeksu pracy, przypadające w okresie od dnia 1 stycznia 2003 r. do dnia 31 grudnia 2003 r.)</em>
                        </ea:Section>
					</td>
				</tr>
			</tbody>
			</table>
						
			<ea:pagebreak id="PageBreak4" runat="server" Required="False"></ea:pagebreak>
			
			<table id="Table9" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="30px" valign="top" align="right">5.</td><td width="5px"></td>
					<td>Informacja o zajęciu wynagrodzenia
                        <ea:Section ID="desc12" runat="server">
                            <em>(oznaczenie komornika i numer sprawy egzekucyjnej)</em>:&nbsp;
                        </ea:Section>
						<ea:datalabel id="komornik" runat="server" Bold="false"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">6.</td><td width="5px"></td>
					<td>Informacje uzupełniające:&nbsp;
						<ea:datalabel id="dodatkowe" runat="server"></ea:datalabel><br/><br/>
					</td>
				</tr>
			</tbody>
			</table>
			
			<table id="Table11" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:right">
			<tbody>
				<tr height="30px">
					<td>&nbsp;</td>
				</tr>
				<tr>
					<td width="50%"></td>
					<td>.............................................................&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
				</tr>
				<tr>
					<td width="50%"></td>
					<td>
						<font size="1">pieczęć i podpis pracodawcy lub osoby działającej w jego imieniu</font>
					</td>
				</tr>
			</tbody>
			</table>
						
			<ea:pagebreak id="PageBreak6" runat="server" Required="False"></ea:pagebreak>
			
			<font face="Tahoma" size="1">
				<p style="text-align:justify">POUCZENIE<br/>
					Pracownik może w ciągu 7 dni od dnia otrzymania świadectwa pracy wystąpić do 
					pracodawcy z wnioskiem o sprostowanie tego świadectwa. W razie nieuwzględnienia 
					wniosku pracownikowi przysługuje, w ciągu 7 dni od dnia otrzymania 
					zawiadomienia o odmowie sprostowania świadectwa pracy, prawo wystąpienia z 
					żądaniem sprostowania świadectwa pracy do 
                    <ea:datalabel id="sadpracy" runat="server" Bold="false"></ea:datalabel>                    
                    (podstawa prawna - art. 97 § 2<sup>1</sup> Kodeksu pracy) 
				</p>
			</font>
			<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			<ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
        </form>
	</body>
</HTML>
